using System.Windows.Forms;

using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.AutoContainers;
using Borland.Eco.UmlRt;
using Borland.Eco.Services;
using Borland.Eco.ModelLayer;

namespace ModelAuditor
{
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>

	public class EditRuleFormFactory: IAutoContainerFactory
	{
		private EditRuleForm editRuleForm;
		public EditRuleForm EditRuleForm
		{
			get
			{
				if ((editRuleForm == null) || (editRuleForm.Disposing) || (editRuleForm.IsDisposed))
				{
					//MessageBox.Show("Creating new");
					editRuleForm = new EditRuleForm();
				}
				return editRuleForm;
			}
		}
		// IAutoContainerFactory
		public IAutoContainer AutoContainer { get { return EditRuleForm; } }
		// IAutoContainerFactory
		public bool Matches(IModelElement modelElement)
		{
			return (modelElement is IClassifier) && (((IClassifier)modelElement).Name == "AuditRule");
		}
	}

	public class EditRuleForm : System.Windows.Forms.Form, IAutoContainer
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox NameTextBox;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox ContextExpressionTextBox;
		private System.Windows.Forms.TextBox RuleExpressionTextBox;
		private System.Windows.Forms.Button OkButton;
		private Borland.Eco.Handles.ReferenceHandle rh;
		private Borland.Eco.WinForm.EcoActionExtender ecoActionExtender1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.TextBox DescriptionTextBox;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Button button2;

		public EditRuleForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		private ModelAuditorEcoSpace ecoSpace;

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.NameTextBox = new System.Windows.Forms.TextBox();
			this.rh = new Borland.Eco.Handles.ReferenceHandle();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.ContextExpressionTextBox = new System.Windows.Forms.TextBox();
			this.RuleExpressionTextBox = new System.Windows.Forms.TextBox();
			this.OkButton = new System.Windows.Forms.Button();
			this.ecoActionExtender1 = new Borland.Eco.WinForm.EcoActionExtender();
			this.button1 = new System.Windows.Forms.Button();
			this.DescriptionTextBox = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.button2 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.TabIndex = 7;
			this.label1.Text = "Rule name:";
			// 
			// NameTextBox
			// 
			this.NameTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.NameTextBox.DataBindings.Add(new System.Windows.Forms.Binding("Text", this.rh, "Name"));
			this.NameTextBox.Location = new System.Drawing.Point(16, 32);
			this.NameTextBox.Name = "NameTextBox";
			this.NameTextBox.Size = new System.Drawing.Size(92, 20);
			this.NameTextBox.TabIndex = 1;
			this.NameTextBox.Text = "";
			// 
			// rh
			// 
			this.rh.EcoSpaceType = typeof(ModelAuditor.ModelAuditorEcoSpace);
			this.rh.StaticValueTypeName = "AuditRule";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 64);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(120, 23);
			this.label2.TabIndex = 8;
			this.label2.Text = "Context expression:";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 112);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(100, 40);
			this.label3.TabIndex = 9;
			this.label3.Text = "Rule expression:";
			// 
			// ContextExpressionTextBox
			// 
			this.ContextExpressionTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.ContextExpressionTextBox.DataBindings.Add(new System.Windows.Forms.Binding("Text", this.rh, "ContextExpression"));
			this.ContextExpressionTextBox.Location = new System.Drawing.Point(16, 80);
			this.ContextExpressionTextBox.Name = "ContextExpressionTextBox";
			this.ContextExpressionTextBox.Size = new System.Drawing.Size(216, 20);
			this.ContextExpressionTextBox.TabIndex = 2;
			this.ContextExpressionTextBox.Text = "";
			// 
			// RuleExpressionTextBox
			// 
			this.RuleExpressionTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.RuleExpressionTextBox.DataBindings.Add(new System.Windows.Forms.Binding("Text", this.rh, "RuleExpression"));
			this.RuleExpressionTextBox.Location = new System.Drawing.Point(16, 128);
			this.RuleExpressionTextBox.Name = "RuleExpressionTextBox";
			this.RuleExpressionTextBox.Size = new System.Drawing.Size(216, 20);
			this.RuleExpressionTextBox.TabIndex = 4;
			this.RuleExpressionTextBox.Text = "";
			// 
			// OkButton
			// 
			this.OkButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.OkButton.Location = new System.Drawing.Point(160, 301);
			this.OkButton.Name = "OkButton";
			this.OkButton.TabIndex = 6;
			this.OkButton.Text = "OK";
			this.OkButton.Click += new System.EventHandler(this.OkButton_Click);
			// 
			// ecoActionExtender1
			// 
			this.ecoActionExtender1.RootHandle = this.rh;
			// 
			// button1
			// 
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.button1.Location = new System.Drawing.Point(232, 80);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(24, 23);
			this.button1.TabIndex = 3;
			this.button1.Text = "...";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// DescriptionTextBox
			// 
			this.DescriptionTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.DescriptionTextBox.DataBindings.Add(new System.Windows.Forms.Binding("Text", this.rh, "Description"));
			this.DescriptionTextBox.Location = new System.Drawing.Point(16, 176);
			this.DescriptionTextBox.Multiline = true;
			this.DescriptionTextBox.Name = "DescriptionTextBox";
			this.DescriptionTextBox.Size = new System.Drawing.Size(216, 109);
			this.DescriptionTextBox.TabIndex = 5;
			this.DescriptionTextBox.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 160);
			this.label4.Name = "label4";
			this.label4.TabIndex = 10;
			this.label4.Text = "Description:";
			// 
			// button2
			// 
			this.button2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.button2.Location = new System.Drawing.Point(232, 128);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(24, 23);
			this.button2.TabIndex = 11;
			this.button2.Text = "...";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// EditRuleForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(264, 334);
			this.Controls.Add(this.button2);
			this.Controls.Add(this.DescriptionTextBox);
			this.Controls.Add(this.RuleExpressionTextBox);
			this.Controls.Add(this.ContextExpressionTextBox);
			this.Controls.Add(this.NameTextBox);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.OkButton);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.label4);
			this.Name = "EditRuleForm";
			this.Text = "Audit Rule";
			this.ResumeLayout(false);
		}
		#endregion

		private void OkButton_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

#region IAutoContainer implementation
		public void BuildControls(IElement element, AutoContainerArgs autoContainerArgs)
		{
		}

		public void HookUpGUI(EcoSpace ecoSpace, IElement element)
		{
			rh.SetElement(element);
		}

		public void Show(AutoContainerArgs autoContainerArgs)
		{
			if (autoContainerArgs.ShowModal)
				ShowDialog();
			else
				Show();
		}

		public EcoSpace EcoSpace
		{
			set { rh.EcoSpace = value; }
		}
#endregion

		private AuditRule CurrentRule { get { return rh.Element.AsObject as AuditRule; } }

		private void button1_Click(object sender, System.EventArgs e)
		{
			EcoModelLayerSpace modelSpace = MainForm.CurrentModel.Space;
			ITypeService typeService = (IOclService)modelSpace.GetEcoService(typeof(IOclService));

			DialogResult res = OclEditor.ShowEditor(typeService, modelSpace.TypeSystem, null, ContextExpressionTextBox.Text, null);
			if (res != DialogResult.Cancel)
				CurrentRule.ContextExpression = OclEditor.OclExpression;
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			EcoModelLayerSpace modelSpace = MainForm.CurrentModel.Space;
			IOclTypeService oclTypeService = (IOclTypeService)modelSpace.GetEcoService(typeof(IOclTypeService));
			IClassifier umlType = oclTypeService.ExpressionType(ContextExpressionTextBox.Text, null, false);

			if (umlType != null)
			{
				if (umlType.ClassifierType == ClassifierType.Collection)
					umlType = ((ICollectionType)umlType).ElementType;

				ITypeService typeService = (IOclService)modelSpace.GetEcoService(typeof(IOclService));

				DialogResult res = OclEditor.ShowEditor(typeService, modelSpace.TypeSystem, umlType, RuleExpressionTextBox.Text, null);
				if (res != DialogResult.Cancel)
					CurrentRule.RuleExpression = OclEditor.OclExpression;
			}
		}
	}
}
